<?php
include 'db.php';
include 'koneksi.php';
include 'session_check.php'; // Cek apakah user sudah login

$username = $_SESSION['username'] ?? 'Guest';
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Dashboard Sistem Perkuliahan</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

  <div class="flex">
    <!-- Sidebar -->
    <div class="w-64 bg-blue-900 min-h-screen p-4 text-white">
      <h1 class="text-2xl font-bold mb-6">Sistem Perkuliahan</h1>
      <nav class="space-y-1">
        <a href="index.php" class="block py-2 px-4 rounded bg-blue-700">🏠 Dashboard</a>
        <a href="mahasiswa.php" class="block py-2 px-4 rounded hover:bg-blue-700">👨‍🎓 Kelola Mahasiswa</a>
        <a href="mata_kuliah.php" class="block py-2 px-4 rounded hover:bg-blue-700">📘 Kelola Mata Kuliah</a>
        <a href="dosen.php" class="block py-2 px-4 rounded hover:bg-blue-700">🧑‍🏫 Kelola Dosen</a>
        <a href="input_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📝 Input Nilai</a>
        <a href="view_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📊 View Nilai</a>
        <hr class="my-3 border-gray-700">
        <a href="users.php" class="block py-2 px-4 rounded hover:bg-blue-700">👥 Manajemen User</a>
        <a href="logout.php" class="block py-2 px-4 bg-red-600 rounded hover:bg-red-700">🚪 Logout</a>
      </nav>
    </div>

    <!-- Main Content -->
    <div class="flex-1 p-8">
      <!-- User Login Info -->
      <div class="flex justify-end items-center mb-4">
        <div class="flex items-center space-x-2 bg-white px-4 py-2 rounded shadow text-sm">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600" viewBox="0 0 20 20" fill="currentColor">
            <path fill-rule="evenodd" d="M10 2a5 5 0 00-3 9.17V13a3 3 0 003 3h2a3 3 0 003-3v-1.83A5 5 0 0010 2zM8 13v-1.14A6.97 6.97 0 0110 12c.69 0 1.36-.1 2-.29V13a1 1 0 01-1 1h-2a1 1 0 01-1-1z" clip-rule="evenodd" />
          </svg>
          <span class="text-gray-700">Login sebagai: <strong><?= htmlspecialchars($username) ?></strong></span>
        </div>
      </div>

      <h2 class="text-3xl font-semibold mb-6">Dashboard</h2>

      <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Mahasiswa -->
        <div class="bg-white p-6 rounded-lg shadow">
          <h3 class="text-xl font-bold mb-2">Total Mahasiswa</h3>
          <?php
            $data = mysqli_query($koneksi, "SELECT COUNT(*) as total FROM mahasiswa");
            $d = mysqli_fetch_assoc($data);
            echo "<p class='text-2xl text-blue-700'>{$d['total']}</p>";
          ?>
        </div>

        <!-- Mata Kuliah -->
        <div class="bg-white p-6 rounded-lg shadow">
          <h3 class="text-xl font-bold mb-2">Total Mata Kuliah</h3>
          <?php
            $data = mysqli_query($koneksi, "SELECT COUNT(*) as total FROM mata_kuliah");
            $d = mysqli_fetch_assoc($data);
            echo "<p class='text-2xl text-green-700'>{$d['total']}</p>";
          ?>
        </div>

        <!-- Dosen -->
        <div class="bg-white p-6 rounded-lg shadow">
          <h3 class="text-xl font-bold mb-2">Total Dosen</h3>
          <?php
            $data = mysqli_query($koneksi, "SELECT COUNT(*) as total FROM dosen");
            $d = mysqli_fetch_assoc($data);
            echo "<p class='text-2xl text-purple-700'>{$d['total']}</p>";
          ?>
        </div>
      </div>

      

    </div>
  </div>

</body>
</html>
