CREATE DATABASE IF NOT EXISTS sistem_perkuliahan_versi2;
USE sistem_perkuliahan_versi2;

-- Tabel jurusan
CREATE TABLE jurusan (
  id INT PRIMARY KEY AUTO_INCREMENT,
  nama_jurusan VARCHAR(100),
  kode_jurusan VARCHAR(10)
);

-- Tabel mahasiswa
CREATE TABLE mahasiswa (
  id INT PRIMARY KEY AUTO_INCREMENT,
  nama VARCHAR(100),
  nim VARCHAR(20),
  id_jurusan INT,
  FOREIGN KEY (id_jurusan) REFERENCES jurusan(id)
);

-- Tabel mata_kuliah
CREATE TABLE mata_kuliah (
  id INT PRIMARY KEY AUTO_INCREMENT,
  nama_mk VARCHAR(100),
  kode_mk VARCHAR(20),
  sks INT
);

-- Tabel dosen
CREATE TABLE dosen (
  id INT PRIMARY KEY AUTO_INCREMENT,
  nama VARCHAR(100),
  nip VARCHAR(20),
  id_mata_kuliah INT,
  FOREIGN KEY (id_mata_kuliah) REFERENCES mata_kuliah(id)
);

-- Tabel nilai
CREATE TABLE nilai (
  id INT PRIMARY KEY AUTO_INCREMENT,
  id_mahasiswa INT,
  id_mata_kuliah INT,
  nilai INT,
  grade VARCHAR(2),
  status VARCHAR(20),
  FOREIGN KEY (id_mahasiswa) REFERENCES mahasiswa(id),
  FOREIGN KEY (id_mata_kuliah) REFERENCES mata_kuliah(id)
);

-- Membuat tabel `users`
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` varchar(20) DEFAULT 'user',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


-- Insert sample data (optional, untuk testing)
INSERT INTO jurusan (nama_jurusan, kode_jurusan) VALUES ('Informatika', 'IF');

INSERT INTO mahasiswa (nama, nim, id_jurusan) VALUES
('Rina', '221001', 1),
('Budi', '221002', 1);

INSERT INTO mata_kuliah (nama_mk, kode_mk, sks) VALUES
('Basis Data', 'BD01', 3),
('Pemrograman Web', 'PW01', 2);

INSERT INTO nilai (id_mahasiswa, id_mata_kuliah, nilai) VALUES
(1, 1, 85),
(1, 2, 70),
(2, 1, 65),
(2, 2, 55);

-- Insert data admin default
INSERT INTO `users` (`id`, `username`, `password`, `role`) VALUES
(1, 'admin', '$2y$10$ZkzJ6F/WNE3.Y1zSoHHDLudf0J1EJMnZUbqkAeL/kw/m8jV9GN1qO', 'admin');
